/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.nestedDichotomies;

import java.util.Hashtable;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.J48;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Range;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;
import weka.filters.unsupervised.instance.RemoveWithValues;

public class ClassBalancedND
extends RandomizableSingleClassifierEnhancer
implements TechnicalInformationHandler {
    static final long serialVersionUID = 5944063630650811903L;
    protected FilteredClassifier m_FilteredClassifier;
    protected Hashtable m_classifiers;
    protected ClassBalancedND m_FirstSuccessor = null;
    protected ClassBalancedND m_SecondSuccessor = null;
    protected Range m_Range = null;
    protected boolean m_hashtablegiven = false;

    public ClassBalancedND() {
        this.m_Classifier = new J48();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Lin Dong and Eibe Frank and Stefan Kramer");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Ensembles of Balanced Nested Dichotomies for Multi-class Problems");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "PKDD");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2005");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "84-95");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Stefan Kramer");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Ensembles of nested dichotomies for multi-class problems");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "Twenty-first International Conference on Machine Learning");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2004");
        technicalInformation2.setValue(TechnicalInformation.Field.PUBLISHER, "ACM");
        return technicalInformation;
    }

    public void setHashtable(Hashtable hashtable) {
        this.m_hashtablegiven = true;
        this.m_classifiers = hashtable;
    }

    private void generateClassifierForNode(Instances instances, Range range, Random random, Classifier classifier, Hashtable hashtable) throws Exception {
        Instances instances2;
        RemoveWithValues removeWithValues;
        int n;
        int n2;
        int n3;
        int[] nArray = range.getSelection();
        for (n3 = nArray.length - 1; n3 > 0; --n3) {
            n2 = random.nextInt(n3 + 1);
            int n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
        }
        n3 = nArray.length / 2;
        n2 = nArray.length - n3;
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        System.arraycopy(nArray, n3, nArray3, 0, n2);
        int[] nArray4 = Utils.sort(nArray2);
        int[] nArray5 = Utils.sort(nArray3);
        int[] nArray6 = new int[n3];
        int[] nArray7 = new int[n2];
        for (n = 0; n < nArray4.length; ++n) {
            nArray6[n] = nArray2[nArray4[n]];
        }
        nArray2 = nArray6;
        for (n = 0; n < nArray5.length; ++n) {
            nArray7[n] = nArray3[nArray5[n]];
        }
        nArray3 = nArray7;
        if (nArray2[0] > nArray3[0]) {
            int[] nArray8 = nArray3;
            nArray3 = nArray2;
            nArray2 = nArray8;
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        this.m_Range = new Range(Range.indicesToRangeList(nArray2));
        this.m_Range.setUpper(instances.numClasses() - 1);
        Range range2 = new Range(Range.indicesToRangeList(nArray3));
        range2.setUpper(instances.numClasses() - 1);
        MakeIndicator makeIndicator = new MakeIndicator();
        makeIndicator.setAttributeIndex("" + (instances.classIndex() + 1));
        makeIndicator.setValueIndices(this.m_Range.getRanges());
        makeIndicator.setNumeric(false);
        makeIndicator.setInputFormat(instances);
        this.m_FilteredClassifier = new FilteredClassifier();
        if (instances.numInstances() > 0) {
            this.m_FilteredClassifier.setClassifier(Classifier.makeCopies(classifier, 1)[0]);
        } else {
            this.m_FilteredClassifier.setClassifier(new ZeroR());
        }
        this.m_FilteredClassifier.setFilter(makeIndicator);
        this.m_classifiers = hashtable;
        if (!this.m_classifiers.containsKey(this.getString(nArray2) + "|" + this.getString(nArray3))) {
            this.m_FilteredClassifier.buildClassifier(instances);
            this.m_classifiers.put(this.getString(nArray2) + "|" + this.getString(nArray3), this.m_FilteredClassifier);
        } else {
            this.m_FilteredClassifier = (FilteredClassifier)this.m_classifiers.get(this.getString(nArray2) + "|" + this.getString(nArray3));
        }
        this.m_FirstSuccessor = new ClassBalancedND();
        if (n3 == 1) {
            this.m_FirstSuccessor.m_Range = this.m_Range;
        } else {
            removeWithValues = new RemoveWithValues();
            removeWithValues.setInvertSelection(true);
            removeWithValues.setNominalIndices(this.m_Range.getRanges());
            removeWithValues.setAttributeIndex("" + (instances.classIndex() + 1));
            removeWithValues.setInputFormat(instances);
            instances2 = Filter.useFilter(instances, removeWithValues);
            this.m_FirstSuccessor.generateClassifierForNode(instances2, this.m_Range, random, classifier, this.m_classifiers);
        }
        this.m_SecondSuccessor = new ClassBalancedND();
        if (n2 == 1) {
            this.m_SecondSuccessor.m_Range = range2;
        } else {
            removeWithValues = new RemoveWithValues();
            removeWithValues.setInvertSelection(true);
            removeWithValues.setNominalIndices(range2.getRanges());
            removeWithValues.setAttributeIndex("" + (instances.classIndex() + 1));
            removeWithValues.setInputFormat(instances);
            instances2 = Filter.useFilter(instances, removeWithValues);
            this.m_SecondSuccessor = new ClassBalancedND();
            this.m_SecondSuccessor.generateClassifierForNode(instances2, range2, random, classifier, this.m_classifiers);
        }
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAllClasses();
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(1);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        Random random = instances.getRandomNumberGenerator(this.m_Seed);
        if (!this.m_hashtablegiven) {
            this.m_classifiers = new Hashtable();
        }
        boolean[] blArray = new boolean[instances.numClasses()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            blArray[(int)instances.instance((int)i).classValue()] = true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(i + 1);
        }
        Range range = new Range(stringBuffer.toString());
        range.setUpper(instances.numClasses() - 1);
        this.generateClassifierForNode(instances, range, random, this.m_Classifier, this.m_classifiers);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        if (this.m_FirstSuccessor == null) {
            for (int i = 0; i < instance.numClasses(); ++i) {
                if (!this.m_Range.isInRange(i)) continue;
                dArray[i] = 1.0;
            }
            return dArray;
        }
        double[] dArray2 = this.m_FirstSuccessor.distributionForInstance(instance);
        double[] dArray3 = this.m_SecondSuccessor.distributionForInstance(instance);
        double[] dArray4 = this.m_FilteredClassifier.distributionForInstance(instance);
        for (int i = 0; i < instance.numClasses(); ++i) {
            if (dArray2[i] > 0.0 && dArray3[i] > 0.0) {
                System.err.println("Panik!!");
            }
            dArray[i] = this.m_Range.isInRange(i) ? dArray4[1] * dArray2[i] : dArray4[0] * dArray3[i];
        }
        return dArray;
    }

    public String getString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[i]);
        }
        return stringBuffer.toString();
    }

    public String globalInfo() {
        return "A meta classifier for handling multi-class datasets with 2-class classifiers by building a random class-balanced tree structure.\n\nFor more info, check\n\n" + this.getTechnicalInformation().toString();
    }

    public String toString() {
        if (this.m_classifiers == null) {
            return "ClassBalancedND: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ClassBalancedND");
        this.treeToString(stringBuffer, 0);
        return stringBuffer.toString();
    }

    private int treeToString(StringBuffer stringBuffer, int n) {
        stringBuffer.append("\n\nNode number: " + ++n + "\n\n");
        if (this.m_FilteredClassifier != null) {
            stringBuffer.append(this.m_FilteredClassifier);
        } else {
            stringBuffer.append("null");
        }
        if (this.m_FirstSuccessor != null) {
            n = this.m_FirstSuccessor.treeToString(stringBuffer, n);
            n = this.m_SecondSuccessor.treeToString(stringBuffer, n);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        ClassBalancedND.runClassifier(new ClassBalancedND(), stringArray);
    }
}

