/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.RegOptimizer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class RegSMO
extends RegOptimizer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -7504070793279598638L;
    protected double m_eps = 1.0E-12;
    protected static final double m_Del = 1.0E-10;
    double[] m_error;
    protected double m_alpha1;
    protected double m_alpha1Star;
    protected double m_alpha2;
    protected double m_alpha2Star;

    public String globalInfo() {
        return "Implementation of SMO for support vector regression as described in :\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MISC);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "A.J. Smola and B. Schoelkopf");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "A tutorial on support vector regression");
        technicalInformation.setValue(TechnicalInformation.Field.NOTE, "NeuroCOLT2 Technical Report NC2-TR-1998-030");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1998");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe epsilon for round-off error.\n\t(default 1.0e-12)", "P", 1, "-P <double>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setEpsilon(Double.parseDouble(string));
        } else {
            this.setEpsilon(1.0E-12);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-P");
        vector.add("" + this.getEpsilon());
        return vector.toArray(new String[vector.size()]);
    }

    public String epsilonTipText() {
        return "The epsilon for round-off error (shouldn't be changed).";
    }

    public double getEpsilon() {
        return this.m_eps;
    }

    public void setEpsilon(double d) {
        this.m_eps = d;
    }

    protected void init(Instances instances) throws Exception {
        super.init(instances);
        this.m_error = new double[this.m_nInstances];
        for (int i = 0; i < this.m_nInstances; ++i) {
            this.m_error[i] = -this.m_target[i];
        }
    }

    protected void wrapUp() throws Exception {
        this.m_error = null;
        super.wrapUp();
    }

    protected boolean findOptimalPointOnLine(int n, double d, double d2, double d3, int n2, double d4, double d5, double d6, double d7, double d8, double d9) {
        if (d8 <= 0.0) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        while (!bl5) {
            double d10;
            double d11;
            double d12;
            double d13;
            if (!bl && (d > 0.0 || d2 == 0.0 && d9 > 0.0) && (d4 > 0.0 || d5 == 0.0 && d9 < 0.0)) {
                d13 = Math.max(0.0, d7 - d3);
                if (d13 < (d12 = Math.min(d6, d7))) {
                    d11 = d4 - d9 / d8;
                    d11 = Math.min(d11, d12);
                    if ((d11 = Math.max(d13, d11)) > d6 - 1.0E-10 * d6) {
                        d11 = d6;
                    } else if (d11 <= 1.0E-10 * d6) {
                        d11 = 0.0;
                    }
                    d10 = d - (d11 - d4);
                    if (d10 > d3 - 1.0E-10 * d3) {
                        d10 = d3;
                    } else if (d10 <= 1.0E-10 * d3) {
                        d10 = 0.0;
                    }
                    if (Math.abs(d - d10) > this.m_eps) {
                        d9 += d8 * (d11 - d4);
                        d = d10;
                        d4 = d11;
                    }
                } else {
                    bl5 = true;
                }
                bl = true;
                continue;
            }
            if (!bl2 && (d > 0.0 || d2 == 0.0 && d9 > 2.0 * this.m_epsilon) && (d5 > 0.0 || d4 == 0.0 && d9 > 2.0 * this.m_epsilon)) {
                d13 = Math.max(0.0, -d7);
                if (d13 < (d12 = Math.min(d6, -d7 + d3))) {
                    d11 = d5 + (d9 - 2.0 * this.m_epsilon) / d8;
                    d11 = Math.min(d11, d12);
                    if ((d11 = Math.max(d13, d11)) > d6 - 1.0E-10 * d6) {
                        d11 = d6;
                    } else if (d11 <= 1.0E-10 * d6) {
                        d11 = 0.0;
                    }
                    d10 = d + (d11 - d5);
                    if (d10 > d3 - 1.0E-10 * d3) {
                        d10 = d3;
                    } else if (d10 <= 1.0E-10 * d3) {
                        d10 = 0.0;
                    }
                    if (Math.abs(d - d10) > this.m_eps) {
                        d9 += d8 * (-d11 + d5);
                        d = d10;
                        d5 = d11;
                    }
                } else {
                    bl5 = true;
                }
                bl2 = true;
                continue;
            }
            if (!bl3 && (d2 > 0.0 || d == 0.0 && d9 < -2.0 * this.m_epsilon) && (d4 > 0.0 || d5 == 0.0 && d9 < -2.0 * this.m_epsilon)) {
                d13 = Math.max(0.0, d7);
                if (d13 < (d12 = Math.min(d6, d3 + d7))) {
                    d11 = d4 - (d9 + 2.0 * this.m_epsilon) / d8;
                    d11 = Math.min(d11, d12);
                    if ((d11 = Math.max(d13, d11)) > d6 - 1.0E-10 * d6) {
                        d11 = d6;
                    } else if (d11 <= 1.0E-10 * d6) {
                        d11 = 0.0;
                    }
                    d10 = d2 + (d11 - d4);
                    if (d10 > d3 - 1.0E-10 * d3) {
                        d10 = d3;
                    } else if (d10 <= 1.0E-10 * d3) {
                        d10 = 0.0;
                    }
                    if (Math.abs(d2 - d10) > this.m_eps) {
                        d9 += d8 * (d11 - d4);
                        d2 = d10;
                        d4 = d11;
                    }
                } else {
                    bl5 = true;
                }
                bl3 = true;
                continue;
            }
            if (!bl4 && (d2 > 0.0 || d == 0.0 && d9 < 0.0) && (d5 > 0.0 || d4 == 0.0 && d9 > 0.0)) {
                d13 = Math.max(0.0, -d7 - d3);
                if (d13 < (d12 = Math.min(d6, -d7))) {
                    d11 = d5 + d9 / d8;
                    d11 = Math.min(d11, d12);
                    if ((d11 = Math.max(d13, d11)) > d6 - 1.0E-10 * d6) {
                        d11 = d6;
                    } else if (d11 <= 1.0E-10 * d6) {
                        d11 = 0.0;
                    }
                    d10 = d2 - (d11 - d5);
                    if (d10 > d3 - 1.0E-10 * d3) {
                        d10 = d3;
                    } else if (d10 <= 1.0E-10 * d3) {
                        d10 = 0.0;
                    }
                    if (Math.abs(d2 - d10) > this.m_eps) {
                        d9 += d8 * (-d11 + d5);
                        d2 = d10;
                        d5 = d11;
                    }
                } else {
                    bl5 = true;
                }
                bl4 = true;
                continue;
            }
            bl5 = true;
        }
        if (Math.abs(d - this.m_alpha[n]) > this.m_eps || Math.abs(d2 - this.m_alphaStar[n]) > this.m_eps || Math.abs(d4 - this.m_alpha[n2]) > this.m_eps || Math.abs(d5 - this.m_alphaStar[n2]) > this.m_eps) {
            if (d > d3 - 1.0E-10 * d3) {
                d = d3;
            } else if (d <= 1.0E-10 * d3) {
                d = 0.0;
            }
            if (d2 > d3 - 1.0E-10 * d3) {
                d2 = d3;
            } else if (d2 <= 1.0E-10 * d3) {
                d2 = 0.0;
            }
            if (d4 > d6 - 1.0E-10 * d6) {
                d4 = d6;
            } else if (d4 <= 1.0E-10 * d6) {
                d4 = 0.0;
            }
            if (d5 > d6 - 1.0E-10 * d6) {
                d5 = d6;
            } else if (d5 <= 1.0E-10 * d6) {
                d5 = 0.0;
            }
            this.m_alpha[n] = d;
            this.m_alphaStar[n] = d2;
            this.m_alpha[n2] = d4;
            this.m_alphaStar[n2] = d5;
            if (d != 0.0 || d2 != 0.0) {
                if (!this.m_supportVectors.contains(n)) {
                    this.m_supportVectors.insert(n);
                }
            } else {
                this.m_supportVectors.delete(n);
            }
            if (d4 != 0.0 || d5 != 0.0) {
                if (!this.m_supportVectors.contains(n2)) {
                    this.m_supportVectors.insert(n2);
                }
            } else {
                this.m_supportVectors.delete(n2);
            }
            return true;
        }
        return false;
    }

    protected int takeStep(int n, int n2, double d, double d2, double d3) throws Exception {
        double d4;
        if (n == n2) {
            return 0;
        }
        double d5 = this.m_C * this.m_data.instance(n).weight();
        double d6 = this.m_C * this.m_data.instance(n2).weight();
        double d7 = this.m_alpha[n];
        double d8 = this.m_alphaStar[n];
        double d9 = this.m_target[n];
        double d10 = this.m_error[n];
        double d11 = this.m_kernel.eval(n, n, this.m_data.instance(n));
        double d12 = this.m_kernel.eval(n, n2, this.m_data.instance(n));
        double d13 = -2.0 * d12 + d11 + (d4 = this.m_kernel.eval(n2, n2, this.m_data.instance(n2)));
        if (d13 < 0.0) {
            return 0;
        }
        double d14 = d7 - d8 + d - d2;
        double d15 = d7;
        double d16 = d8;
        double d17 = d;
        double d18 = d2;
        double d19 = d3 - d10;
        if (this.findOptimalPointOnLine(n, d7, d8, d5, n2, d, d2, d6, d14, d13, d19)) {
            d7 = this.m_alpha[n];
            d8 = this.m_alphaStar[n];
            d = this.m_alpha[n2];
            d2 = this.m_alphaStar[n2];
            double d20 = d7 - d15 - (d8 - d16);
            double d21 = d - d17 - (d2 - d18);
            for (int i = 0; i < this.m_nInstances; ++i) {
                if (i == n || i == n2) continue;
                int n3 = i;
                this.m_error[n3] = this.m_error[n3] + (d20 * this.m_kernel.eval(n, i, this.m_data.instance(n)) + d21 * this.m_kernel.eval(n2, i, this.m_data.instance(n2)));
            }
            int n4 = n;
            this.m_error[n4] = this.m_error[n4] + (d20 * d11 + d21 * d12);
            int n5 = n2;
            this.m_error[n5] = this.m_error[n5] + (d20 * d12 + d21 * d4);
            double d22 = Double.MAX_VALUE;
            double d23 = Double.MAX_VALUE;
            if (0.0 < d7 && d7 < d5 || 0.0 < d8 && d8 < d5 || 0.0 < d && d < d6 || 0.0 < d2 && d2 < d6) {
                if (0.0 < d7 && d7 < d5) {
                    d22 = this.m_error[n] - this.m_epsilon;
                } else if (0.0 < d8 && d8 < d5) {
                    d22 = this.m_error[n] + this.m_epsilon;
                }
                if (0.0 < d && d < d6) {
                    d23 = this.m_error[n2] - this.m_epsilon;
                } else if (0.0 < d2 && d2 < d6) {
                    d23 = this.m_error[n2] + this.m_epsilon;
                }
                if (d22 < Double.MAX_VALUE) {
                    this.m_b = d22;
                    if (d23 < Double.MAX_VALUE) {
                        this.m_b = (d22 + d23) / 2.0;
                    }
                } else if (d23 < Double.MAX_VALUE) {
                    this.m_b = d23;
                }
            } else if (this.m_b == 0.0) {
                this.m_b = (this.m_error[n] + this.m_error[n2]) / 2.0;
            }
            return 1;
        }
        return 0;
    }

    protected int examineExample(int n) throws Exception {
        double d = this.m_target[n];
        double d2 = this.m_alpha[n];
        double d3 = this.m_alphaStar[n];
        double d4 = this.m_C;
        double d5 = this.m_C;
        double d6 = this.m_error[n];
        double d7 = d6 - this.m_b;
        if (d7 > this.m_epsilon && d3 < d5 || d7 < this.m_epsilon && d3 > 0.0 || -d7 > this.m_epsilon && d2 < d4 || -d7 > this.m_epsilon && d2 > 0.0) {
            int n2 = this.secondChoiceHeuristic(n);
            if (n2 >= 0 && this.takeStep(n2, n, d2, d3, d6) > 0) {
                return 1;
            }
            for (n2 = 0; n2 < this.m_target.length; ++n2) {
                if (!(this.m_alpha[n2] > 0.0 && this.m_alpha[n2] < this.m_C) && (!(this.m_alphaStar[n2] > 0.0) || !(this.m_alphaStar[n2] < this.m_C)) || this.takeStep(n2, n, d2, d3, d6) <= 0) continue;
                return 1;
            }
            for (n2 = 0; n2 < this.m_target.length; ++n2) {
                if (this.takeStep(n2, n, d2, d3, d6) <= 0) continue;
                return 1;
            }
        }
        return 0;
    }

    protected int secondChoiceHeuristic(int n) {
        for (int i = 0; i < 59; ++i) {
            int n2 = this.m_random.nextInt(this.m_nInstances);
            if (!(n2 != n && this.m_alpha[n2] > 0.0 && this.m_alpha[n2] < this.m_C) && (!(this.m_alphaStar[n2] > 0.0) || !(this.m_alphaStar[n2] < this.m_C))) continue;
            return n2;
        }
        return -1;
    }

    public void optimize() throws Exception {
        int n = 0;
        int n2 = 1;
        int n3 = -100;
        int n4 = 0;
        while ((n > 0 || n2 > 0) | n3 < 3) {
            int n5;
            ++n4;
            n = 0;
            int n6 = 0;
            if (n2 > 0) {
                for (n5 = 0; n5 < this.m_nInstances; ++n5) {
                    n += this.examineExample(n5);
                }
            } else {
                for (n5 = 0; n5 < this.m_target.length; ++n5) {
                    if (!(this.m_alpha[n5] > 0.0 && this.m_alpha[n5] < this.m_C * this.m_data.instance(n5).weight()) && (!(this.m_alphaStar[n5] > 0.0) || !(this.m_alphaStar[n5] < this.m_C * this.m_data.instance(n5).weight()))) continue;
                    ++n6;
                    n += this.examineExample(n5);
                }
            }
            n5 = 1;
            if (n4 % 2 == 0) {
                n5 = (int)Math.max(1.0, 0.1 * (double)n6);
            }
            if (n2 == 1) {
                n2 = 0;
            } else if (n < n5) {
                n2 = 1;
            }
            if (n4 != 2500) continue;
            break;
        }
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.init(instances);
        this.optimize();
        this.wrapUp();
    }
}

