/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.local;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.search.local.HillClimber;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class TabuSearch
extends HillClimber
implements TechnicalInformationHandler {
    static final long serialVersionUID = 1457344073228786447L;
    int m_nRuns = 10;
    int m_nTabuList = 5;
    HillClimber.Operation[] m_oTabuList = null;

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.PHDTHESIS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "R.R. Bouckaert");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1995");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Bayesian Belief Networks: from Construction to Inference");
        technicalInformation.setValue(TechnicalInformation.Field.INSTITUTION, "University of Utrecht");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Utrecht, Netherlands");
        return technicalInformation;
    }

    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        this.m_oTabuList = new HillClimber.Operation[this.m_nTabuList];
        int n = 0;
        this.initCache(bayesNet, instances);
        double d = 0.0;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            d += this.calcNodeScore(i);
        }
        double d2 = d;
        BayesNet bayesNet2 = new BayesNet();
        bayesNet2.m_Instances = instances;
        bayesNet2.initStructure();
        this.copyParentSets(bayesNet2, bayesNet);
        for (int i = 0; i < this.m_nRuns; ++i) {
            HillClimber.Operation operation = this.getOptimalOperation(bayesNet, instances);
            this.performOperation(bayesNet, instances, operation);
            if (operation == null) {
                throw new Exception("Panic: could not find any step to make. Tabu list too long?");
            }
            this.m_oTabuList[n] = operation;
            n = (n + 1) % this.m_nTabuList;
            if ((d += operation.m_fDeltaScore) > d2) {
                d2 = d;
                this.copyParentSets(bayesNet2, bayesNet);
            }
            if (!bayesNet.getDebug()) continue;
            this.printTabuList();
        }
        this.copyParentSets(bayesNet, bayesNet2);
        bayesNet2 = null;
        this.m_Cache = null;
    }

    void copyParentSets(BayesNet bayesNet, BayesNet bayesNet2) {
        int n = bayesNet2.getNrOfNodes();
        for (int i = 0; i < n; ++i) {
            bayesNet.getParentSet(i).copy(bayesNet2.getParentSet(i));
        }
    }

    boolean isNotTabu(HillClimber.Operation operation) {
        for (int i = 0; i < this.m_nTabuList; ++i) {
            if (!operation.equals(this.m_oTabuList[i])) continue;
            return false;
        }
        return true;
    }

    void printTabuList() {
        for (int i = 0; i < this.m_nTabuList; ++i) {
            HillClimber.Operation operation = this.m_oTabuList[i];
            if (operation == null) continue;
            if (operation.m_nOperation == 0) {
                System.out.print(" +(");
            } else {
                System.out.print(" -(");
            }
            System.out.print(operation.m_nTail + "->" + operation.m_nHead + ")");
        }
        System.out.println();
    }

    public int getRuns() {
        return this.m_nRuns;
    }

    public void setRuns(int n) {
        this.m_nRuns = n;
    }

    public int getTabuList() {
        return this.m_nTabuList;
    }

    public void setTabuList(int n) {
        this.m_nTabuList = n;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tTabu list length", "L", 1, "-L <integer>"));
        vector.addElement(new Option("\tNumber of runs", "U", 1, "-U <integer>"));
        vector.addElement(new Option("\tMaximum number of parents", "P", 1, "-P <nr of parents>"));
        vector.addElement(new Option("\tUse arc reversal operation.\n\t(default false)", "R", 0, "-R"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2 = Utils.getOption('L', stringArray);
        if (string2.length() != 0) {
            this.setTabuList(Integer.parseInt(string2));
        }
        if ((string = Utils.getOption('U', stringArray)).length() != 0) {
            this.setRuns(Integer.parseInt(string));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[7 + stringArray.length];
        int n = 0;
        stringArray2[n++] = "-L";
        stringArray2[n++] = "" + this.getTabuList();
        stringArray2[n++] = "-U";
        stringArray2[n++] = "" + this.getRuns();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n++] = stringArray[i];
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String globalInfo() {
        return "This Bayes Network learning algorithm uses tabu search for finding a well scoring Bayes network structure. Tabu search is hill climbing till an optimum is reached. The following step is the least worst possible step. The last X steps are kept in a list and none of the steps in this so called tabu list is considered in taking the next step. The best network found in this traversal is returned.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public String runsTipText() {
        return "Sets the number of steps to be performed.";
    }

    public String tabuListTipText() {
        return "Sets the length of the tabu list.";
    }
}

