/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.calendars;

import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.calendars.DefaultGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ChainedGregorianCalendarProvider
implements IGregorianCalendarProvider {
    public final String first;
    public final String second;
    public final Day breakDay;
    private final WeakReference<GregorianCalendarManager> calendarManager;

    public ChainedGregorianCalendarProvider(String first, Day breakDay, String second) {
        this.first = first;
        this.breakDay = breakDay;
        this.second = second;
        this.calendarManager = new WeakReference<GregorianCalendarManager>(ProcessingContext.getActiveContext().getGregorianCalendars());
    }

    public ChainedGregorianCalendarProvider(GregorianCalendarManager calendarManager, String first, Day breakDay, String second) {
        this.first = first;
        this.breakDay = breakDay;
        this.second = second;
        this.calendarManager = new WeakReference<GregorianCalendarManager>(calendarManager);
    }

    @Override
    @Deprecated
    public void calendarData(TradingDaysType dtype, TsDomain domain, List<DataBlock> buffer, int start) {
        this.calendarData(dtype, domain, buffer.subList(start, start + this.count(dtype)));
    }

    @Override
    public void calendarData(TradingDaysType dtype, TsDomain domain, List<DataBlock> buffer) {
        int nvars = this.count(dtype);
        GregorianCalendarManager mgr = (GregorianCalendarManager)this.calendarManager.get();
        if (mgr == null) {
            return;
        }
        if (nvars == 0 || !mgr.contains(this.first) || !mgr.contains(this.second)) {
            return;
        }
        TsPeriod br = new TsPeriod(domain.getFrequency());
        br.set(this.breakDay);
        if (domain.getStart().isNotBefore(br)) {
            ((IGregorianCalendarProvider)mgr.get(this.second)).calendarData(dtype, domain, buffer);
        } else if (domain.getLast().isBefore(br)) {
            ((IGregorianCalendarProvider)mgr.get(this.first)).calendarData(dtype, domain, buffer);
        } else {
            int i;
            int pos = domain.search(br);
            if (pos <= 0) {
                throw new TsException("Unexpected error in chained calendars");
            }
            TsDomain bdom = new TsDomain(domain.getStart(), pos);
            TsDomain edom = domain.drop(pos, 0);
            DataBlock[] tmp = new DataBlock[nvars];
            for (i = 0; i < nvars; ++i) {
                tmp[i] = buffer.get(i).range(0, pos);
            }
            ((IGregorianCalendarProvider)mgr.get(this.first)).calendarData(dtype, bdom, Arrays.asList(tmp));
            for (i = 0; i < nvars; ++i) {
                tmp[i] = buffer.get(i).drop(pos, 0);
            }
            ((IGregorianCalendarProvider)mgr.get(this.second)).calendarData(dtype, edom, Arrays.asList(tmp));
        }
    }

    @Override
    public List<DataBlock> holidays(TradingDaysType dtype, TsDomain domain) {
        GregorianCalendarManager mgr = (GregorianCalendarManager)this.calendarManager.get();
        if (mgr == null) {
            return null;
        }
        int nvars = this.count(dtype);
        if (nvars == 0 || !mgr.contains(this.first) || !mgr.contains(this.second)) {
            return null;
        }
        TsPeriod br = new TsPeriod(domain.getFrequency());
        br.set(this.breakDay);
        if (domain.getStart().isNotBefore(br)) {
            return ((IGregorianCalendarProvider)mgr.get(this.second)).holidays(dtype, domain);
        }
        if (domain.getLast().isBefore(br)) {
            return ((IGregorianCalendarProvider)mgr.get(this.first)).holidays(dtype, domain);
        }
        int pos = domain.search(br);
        if (pos <= 0) {
            throw new TsException("Unexpected error in chained calendars");
        }
        TsDomain bdom = new TsDomain(domain.getStart(), pos);
        TsDomain edom = domain.drop(pos, 0);
        DataBlock[] tmp = new DataBlock[nvars];
        List<DataBlock> bhol = ((IGregorianCalendarProvider)mgr.get(this.first)).holidays(dtype, bdom);
        List<DataBlock> ehol = ((IGregorianCalendarProvider)mgr.get(this.second)).holidays(dtype, edom);
        for (int i = 0; i < nvars; ++i) {
            tmp[i] = new DataBlock(domain.getLength());
            tmp[i].range(0, pos).copy(bhol.get(i));
            tmp[i].drop(pos, 0).copy(ehol.get(i));
        }
        return Arrays.asList(tmp);
    }

    @Override
    public int count(TradingDaysType type) {
        return type.getVariablesCount();
    }

    @Override
    public String getDescription(TradingDaysType dtype, int idx) {
        return DefaultGregorianCalendarProvider.description(dtype, idx);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ChainedGregorianCalendarProvider && this.equals((ChainedGregorianCalendarProvider)obj);
    }

    private boolean equals(ChainedGregorianCalendarProvider other) {
        return other.first.equals(this.first) && other.second.equals(this.second) && other.breakDay.equals((Object)this.breakDay);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.first);
        hash = 97 * hash + Objects.hashCode(this.second);
        hash = 97 * hash + Objects.hashCode(this.breakDay);
        return hash;
    }

    @Override
    public ChainedGregorianCalendarProvider withCalendarManager(GregorianCalendarManager manager) {
        return new ChainedGregorianCalendarProvider(manager, this.first, this.breakDay, this.second);
    }
}

