/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.benchmarking;

import ec.benchmarking.simplets.TsCholette;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import java.util.Map;

public class SaBenchmarkingSpec
implements IProcSpecification,
Cloneable {
    public static double DEF_LAMBDA = 1.0;
    public static double DEF_RHO = 1.0;
    public static final String ENABLED = "enabled";
    public static final String TARGET = "target";
    public static final String FORECAST = "forecast";
    public static final String LAMBDA = "lambda";
    public static final String RHO = "rho";
    public static final String BIAS = "bias";
    private boolean enabled_ = false;
    private boolean forecast_ = false;
    private Target target_ = Target.CalendarAdjusted;
    private double rho_ = DEF_RHO;
    private double lambda_ = DEF_LAMBDA;
    private TsCholette.BiasCorrection bias_ = TsCholette.BiasCorrection.None;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, ENABLED), Boolean.class);
        dic.put(InformationSet.item(prefix, BIAS), String.class);
        dic.put(InformationSet.item(prefix, TARGET), String.class);
        dic.put(InformationSet.item(prefix, FORECAST), Boolean.class);
        dic.put(InformationSet.item(prefix, RHO), Double.class);
        dic.put(InformationSet.item(prefix, LAMBDA), Double.class);
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
    }

    public Target getTarget() {
        return this.target_;
    }

    public void setTarget(Target target) {
        this.target_ = target;
    }

    public double getRho() {
        return this.rho_;
    }

    public void setRho(double rho) {
        this.rho_ = rho;
    }

    public double getLambda() {
        return this.lambda_;
    }

    public void setLambda(double lambda) {
        this.lambda_ = lambda;
    }

    public TsCholette.BiasCorrection getBias() {
        return this.bias_;
    }

    public void setBias(TsCholette.BiasCorrection bias) {
        this.bias_ = bias;
    }

    public boolean isUsingForecast() {
        return this.forecast_;
    }

    public void useForecast(boolean bf) {
        this.forecast_ = bf;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        if (!verbose && !this.enabled_) {
            return info;
        }
        info.add(ENABLED, Boolean.valueOf(this.enabled_));
        if (verbose || this.forecast_) {
            info.add(FORECAST, Boolean.valueOf(this.forecast_));
        }
        info.add(TARGET, this.target_.name());
        if (verbose || this.lambda_ != DEF_LAMBDA) {
            info.add(LAMBDA, Double.valueOf(this.lambda_));
        }
        if (verbose || this.rho_ != DEF_RHO) {
            info.add(RHO, Double.valueOf(this.rho_));
        }
        if (verbose || this.bias_ != TsCholette.BiasCorrection.None) {
            info.add(BIAS, this.bias_.name());
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            String target;
            Double lambda;
            Double rho;
            Boolean enabled = info.get(ENABLED, Boolean.class);
            if (enabled != null) {
                this.enabled_ = enabled;
            }
            if (!this.enabled_) {
                return true;
            }
            Boolean f = info.get(FORECAST, Boolean.class);
            if (f != null) {
                this.forecast_ = f;
            }
            if ((rho = info.get(RHO, Double.class)) != null) {
                this.rho_ = rho;
            }
            if ((lambda = info.get(LAMBDA, Double.class)) != null) {
                this.lambda_ = lambda;
            }
            this.target_ = (target = info.get(TARGET, String.class)) != null ? Target.valueOf(target) : Target.Original;
            String bias = info.get(BIAS, String.class);
            if (bias != null) {
                this.bias_ = TsCholette.BiasCorrection.valueOf(bias);
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    @Override
    public SaBenchmarkingSpec clone() {
        try {
            return (SaBenchmarkingSpec)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(SaBenchmarkingSpec other) {
        return this.enabled_ == other.enabled_ && this.target_ == other.target_ && this.rho_ == other.rho_ && this.lambda_ == other.lambda_ && this.bias_ == other.bias_ && this.forecast_ == other.forecast_;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SaBenchmarkingSpec && this.equals((SaBenchmarkingSpec)obj);
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + (this.enabled_ ? 1 : 0);
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.rho_) ^ Double.doubleToLongBits(this.rho_) >>> 32);
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.lambda_) ^ Double.doubleToLongBits(this.lambda_) >>> 32);
        return hash;
    }

    public static enum Target {
        Original,
        CalendarAdjusted;

    }
}

