/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseRCLongMatrix2D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultFirst;
import cern.jet.math.tlong.LongPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseCCLongMatrix2D
extends WrapperLongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] columnPointers;
    protected int[] rowIndexes;
    protected long[] values;
    protected boolean rowIndexesSorted;

    public SparseCCLongMatrix2D(long[][] lArray) {
        this(lArray.length, lArray[0].length);
        this.assign(lArray);
    }

    public SparseCCLongMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseCCLongMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.rowIndexes = new int[n3];
        this.values = new long[n3];
        this.columnPointers = new int[n2 + 1];
    }

    public SparseCCLongMatrix2D(int n, int n2, int[] nArray, int[] nArray2, long l, boolean bl, boolean bl2) {
        int n3;
        block8: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block8;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (l == 0L) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int n4 = Math.max(nArray.length, 1);
        this.rowIndexes = new int[n4];
        this.values = new long[n4];
        this.columnPointers = new int[n2 + 1];
        int[] nArray3 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.columnPointers, nArray3, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.rowIndexes[var11_12] = nArray[n3];
            this.values[var11_12] = l;
        }
        if (bl) {
            this.removeDuplicates();
        }
        if (bl2) {
            this.sortRowIndexes();
        }
    }

    public SparseCCLongMatrix2D(int n, int n2, int[] nArray, int[] nArray2, long[] lArray, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        block8: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block8;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (nArray.length != lArray.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int n4 = Math.max(nArray.length, 1);
        this.rowIndexes = new int[n4];
        this.values = new long[n4];
        this.columnPointers = new int[n2 + 1];
        int[] nArray3 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.columnPointers, nArray3, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.rowIndexes[var11_13] = nArray[n3];
            this.values[var11_13] = lArray[n3];
        }
        if (bl) {
            this.removeDuplicates();
        }
        if (bl3) {
            this.sortRowIndexes();
        }
    }

    public LongMatrix2D assign(final LongFunction longFunction) {
        if (longFunction instanceof LongMult) {
            long l = ((LongMult)longFunction).multiplicator;
            if (l == 1L) {
                return this;
            }
            if (l == 0L) {
                return this.assign(0L);
            }
            if (l != l) {
                return this.assign(l);
            }
            long[] lArray = this.values;
            int n = this.cardinality();
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                lArray[n3] = lArray[n3] * l;
            }
        } else {
            this.forEachNonZero(new IntIntLongFunction(){

                public long apply(int n, int n2, long l) {
                    return longFunction.apply(l);
                }
            });
        }
        return this;
    }

    public LongMatrix2D assign(long l) {
        if (l == 0L) {
            Arrays.fill(this.rowIndexes, 0);
            Arrays.fill(this.columnPointers, 0);
            Arrays.fill(this.values, 0L);
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values[i] = l;
            }
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D) {
        if (longMatrix2D == this) {
            return this;
        }
        this.checkShape(longMatrix2D);
        if (longMatrix2D instanceof SparseCCLongMatrix2D) {
            SparseCCLongMatrix2D sparseCCLongMatrix2D = (SparseCCLongMatrix2D)longMatrix2D;
            System.arraycopy(sparseCCLongMatrix2D.getColumnPointers(), 0, this.columnPointers, 0, this.columns + 1);
            int n = sparseCCLongMatrix2D.getRowIndexes().length;
            if (this.rowIndexes.length < n) {
                this.rowIndexes = new int[n];
                this.values = new long[n];
            }
            System.arraycopy(sparseCCLongMatrix2D.getRowIndexes(), 0, this.rowIndexes, 0, n);
            System.arraycopy(sparseCCLongMatrix2D.getValues(), 0, this.values, 0, n);
            this.rowIndexesSorted = sparseCCLongMatrix2D.rowIndexesSorted;
        } else if (longMatrix2D instanceof SparseRCLongMatrix2D) {
            SparseRCLongMatrix2D sparseRCLongMatrix2D = ((SparseRCLongMatrix2D)longMatrix2D).getTranspose();
            this.columnPointers = sparseRCLongMatrix2D.getRowPointers();
            this.rowIndexes = sparseRCLongMatrix2D.getColumnIndexes();
            this.values = sparseRCLongMatrix2D.getValues();
            this.rowIndexesSorted = true;
        } else {
            this.assign(0L);
            longMatrix2D.forEachNonZero(new IntIntLongFunction(){

                public long apply(int n, int n2, long l) {
                    SparseCCLongMatrix2D.this.setQuick(n, n2, l);
                    return l;
                }
            });
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D, LongLongFunction longLongFunction) {
        this.checkShape(longMatrix2D);
        if (longMatrix2D instanceof SparseCCLongMatrix2D && longLongFunction == LongFunctions.plus) {
            SparseCCLongMatrix2D sparseCCLongMatrix2D = (SparseCCLongMatrix2D)longMatrix2D;
            int n = 0;
            int n2 = this.rows;
            int n3 = this.columnPointers[this.columns];
            int n4 = sparseCCLongMatrix2D.columns;
            int[] nArray = sparseCCLongMatrix2D.columnPointers;
            int n5 = nArray[n4];
            int[] nArray2 = new int[n2];
            long[] lArray = new long[n2];
            SparseCCLongMatrix2D sparseCCLongMatrix2D2 = new SparseCCLongMatrix2D(n2, n4, n3 + n5);
            int[] nArray3 = sparseCCLongMatrix2D2.columnPointers;
            int[] nArray4 = sparseCCLongMatrix2D2.rowIndexes;
            long[] lArray2 = sparseCCLongMatrix2D2.values;
            for (int i = 0; i < n4; ++i) {
                nArray3[i] = n;
                n = this.scatter(this, i, 1L, nArray2, lArray, i + 1, sparseCCLongMatrix2D2, n);
                n = this.scatter(sparseCCLongMatrix2D, i, 1L, nArray2, lArray, i + 1, sparseCCLongMatrix2D2, n);
                for (int j = nArray3[i]; j < n; ++j) {
                    lArray2[j] = lArray[nArray4[j]];
                }
            }
            nArray3[n4] = n;
            this.rowIndexes = nArray4;
            this.columnPointers = nArray3;
            this.values = lArray2;
            return this;
        }
        if (longLongFunction instanceof LongPlusMultSecond) {
            final long l = ((LongPlusMultSecond)longLongFunction).multiplicator;
            if (l == 0L) {
                return this;
            }
            longMatrix2D.forEachNonZero(new IntIntLongFunction(){

                public long apply(int n, int n2, long l2) {
                    SparseCCLongMatrix2D.this.setQuick(n, n2, SparseCCLongMatrix2D.this.getQuick(n, n2) + l * l2);
                    return l2;
                }
            });
            return this;
        }
        if (longLongFunction instanceof LongPlusMultFirst) {
            final long l = ((LongPlusMultFirst)longLongFunction).multiplicator;
            if (l == 0L) {
                return this.assign(longMatrix2D);
            }
            longMatrix2D.forEachNonZero(new IntIntLongFunction(){

                public long apply(int n, int n2, long l2) {
                    SparseCCLongMatrix2D.this.setQuick(n, n2, l * SparseCCLongMatrix2D.this.getQuick(n, n2) + l2);
                    return l2;
                }
            });
            return this;
        }
        if (longLongFunction == LongFunctions.mult) {
            int[] nArray = this.rowIndexes;
            int[] nArray5 = this.columnPointers;
            long[] lArray = this.values;
            int n = this.columns;
            while (--n >= 0) {
                int n6 = nArray5[n];
                int n7 = nArray5[n + 1];
                while (--n7 >= n6) {
                    int n8 = nArray[n7];
                    int n9 = n7;
                    lArray[n9] = lArray[n9] * longMatrix2D.getQuick(n8, n);
                    if (lArray[n7] != 0L) continue;
                    this.remove(n8, n);
                }
            }
            return this;
        }
        if (longLongFunction == LongFunctions.div) {
            int[] nArray = this.rowIndexes;
            int[] nArray6 = this.columnPointers;
            long[] lArray = this.values;
            int n = this.columns;
            while (--n >= 0) {
                int n10 = nArray6[n];
                int n11 = nArray6[n + 1];
                while (--n11 >= n10) {
                    int n12 = nArray[n11];
                    int n13 = n11;
                    lArray[n13] = lArray[n13] / longMatrix2D.getQuick(n12, n);
                    if (lArray[n11] != 0L) continue;
                    this.remove(n12, n);
                }
            }
            return this;
        }
        return super.assign(longMatrix2D, longLongFunction);
    }

    public int cardinality() {
        return this.columnPointers[this.columns];
    }

    public LongMatrix2D forEachNonZero(IntIntLongFunction intIntLongFunction) {
        int[] nArray = this.rowIndexes;
        int[] nArray2 = this.columnPointers;
        long[] lArray = this.values;
        int n = this.columns;
        while (--n >= 0) {
            int n2 = nArray2[n];
            int n3 = nArray2[n + 1];
            while (--n3 >= n2) {
                long l;
                int n4 = nArray[n3];
                long l2 = lArray[n3];
                lArray[n3] = l = intIntLongFunction.apply(n4, n, l2);
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.columnPointers;
    }

    public DenseLongMatrix2D getDense() {
        final DenseLongMatrix2D denseLongMatrix2D = new DenseLongMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntLongFunction(){

            public long apply(int n, int n2, long l) {
                denseLongMatrix2D.setQuick(n, n2, SparseCCLongMatrix2D.this.getQuick(n, n2));
                return l;
            }
        });
        return denseLongMatrix2D;
    }

    public synchronized long getQuick(int n, int n2) {
        int n3 = SparseCCLongMatrix2D.searchFromTo(this.rowIndexes, n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        long l = 0L;
        if (n3 >= 0) {
            l = this.values[n3];
        }
        return l;
    }

    public SparseRCLongMatrix2D getRowCompressed() {
        SparseCCLongMatrix2D sparseCCLongMatrix2D = this.getTranspose();
        SparseRCLongMatrix2D sparseRCLongMatrix2D = new SparseRCLongMatrix2D(this.rows, this.columns);
        sparseRCLongMatrix2D.columnIndexes = sparseCCLongMatrix2D.rowIndexes;
        sparseRCLongMatrix2D.rowPointers = sparseCCLongMatrix2D.columnPointers;
        sparseRCLongMatrix2D.values = sparseCCLongMatrix2D.values;
        sparseRCLongMatrix2D.columnIndexesSorted = true;
        return sparseRCLongMatrix2D;
    }

    public int[] getRowIndexes() {
        return this.rowIndexes;
    }

    public SparseCCLongMatrix2D getTranspose() {
        int n;
        int n2 = this.rows;
        int n3 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        long[] lArray = this.values;
        SparseCCLongMatrix2D sparseCCLongMatrix2D = new SparseCCLongMatrix2D(this.columns, this.rows, nArray2.length);
        int[] nArray3 = new int[n2];
        int[] nArray4 = sparseCCLongMatrix2D.columnPointers;
        int[] nArray5 = sparseCCLongMatrix2D.rowIndexes;
        long[] lArray2 = sparseCCLongMatrix2D.values;
        for (n = 0; n < nArray[n3]; ++n) {
            int n4 = nArray2[n];
            nArray3[n4] = nArray3[n4] + 1;
        }
        this.cumsum(nArray4, nArray3, n2);
        for (int i = 0; i < n3; ++i) {
            for (n = nArray[i]; n < nArray[i + 1]; ++n) {
                int n5 = nArray2[n];
                nArray3[n5] = nArray3[n5] + 1;
                nArray5[var2_13] = i;
                lArray2[var2_13] = lArray[n];
            }
        }
        return sparseCCLongMatrix2D;
    }

    public long[] getValues() {
        return this.values;
    }

    public boolean hasRowIndexesSorted() {
        return this.rowIndexesSorted;
    }

    public LongMatrix2D like(int n, int n2) {
        return new SparseCCLongMatrix2D(n, n2);
    }

    public LongMatrix1D like1D(int n) {
        return new SparseLongMatrix1D(n);
    }

    public synchronized void setQuick(int n, int n2, long l) {
        int n3 = SparseCCLongMatrix2D.searchFromTo(this.rowIndexes, n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        if (n3 >= 0) {
            if (l == 0L) {
                this.remove(n2, n3);
            } else {
                this.values[n3] = l;
            }
            return;
        }
        if (l != 0L) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, l);
        }
    }

    public void sortRowIndexes() {
        SparseCCLongMatrix2D sparseCCLongMatrix2D = this.getTranspose();
        sparseCCLongMatrix2D = sparseCCLongMatrix2D.getTranspose();
        this.columnPointers = sparseCCLongMatrix2D.columnPointers;
        this.rowIndexes = sparseCCLongMatrix2D.rowIndexes;
        this.values = sparseCCLongMatrix2D.values;
        this.rowIndexesSorted = true;
    }

    public void removeDuplicates() {
        int n;
        int n2 = 0;
        int n3 = this.rows;
        int n4 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        long[] lArray = this.values;
        int[] nArray3 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray3[n] = -1;
        }
        for (int i = 0; i < n4; ++i) {
            int n5 = n2;
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                n = nArray2[j];
                if (nArray3[n] >= n5) {
                    int n6 = nArray3[n];
                    lArray[n6] = lArray[n6] + lArray[j];
                    continue;
                }
                nArray3[n] = n2;
                nArray2[n2] = n;
                lArray[n2++] = lArray[j];
            }
            nArray[i] = n5;
        }
        nArray[n4] = n2;
    }

    public void removeZeroes() {
        int n = 0;
        int n2 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        long[] lArray = this.values;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                if (lArray[j] == 0L) continue;
                lArray[n] = lArray[j];
                nArray2[n++] = nArray2[j];
            }
        }
        nArray[n2] = n;
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.columns; ++i) {
            int n = this.columnPointers[i + 1];
            for (int j = this.columnPointers[i]; j < n; ++j) {
                stringBuilder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public LongMatrix1D zMult(LongMatrix1D longMatrix1D, LongMatrix1D longMatrix1D2, final long l, final long l2, boolean bl) {
        boolean bl2;
        int n = bl ? this.columns : this.rows;
        int n2 = bl ? this.rows : this.columns;
        boolean bl3 = bl2 = longMatrix1D2 == null || bl;
        if (longMatrix1D2 == null) {
            longMatrix1D2 = new DenseLongMatrix1D(n);
        }
        if (!(longMatrix1D instanceof DenseLongMatrix1D) || !(longMatrix1D2 instanceof DenseLongMatrix1D)) {
            return super.zMult(longMatrix1D, longMatrix1D2, l, l2, bl);
        }
        if ((long)n2 != longMatrix1D.size() || (long)n > longMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + longMatrix1D.toStringShort() + ", " + longMatrix1D2.toStringShort());
        }
        DenseLongMatrix1D denseLongMatrix1D = (DenseLongMatrix1D)longMatrix1D2;
        final long[] lArray = denseLongMatrix1D.elements;
        final int n3 = denseLongMatrix1D.stride();
        final int n4 = (int)denseLongMatrix1D.index(0);
        DenseLongMatrix1D denseLongMatrix1D2 = (DenseLongMatrix1D)longMatrix1D;
        final long[] lArray2 = denseLongMatrix1D2.elements;
        final int n5 = denseLongMatrix1D2.stride();
        final int n6 = (int)denseLongMatrix1D2.index(0);
        final int[] nArray = this.rowIndexes;
        final int[] nArray2 = this.columnPointers;
        final long[] lArray3 = this.values;
        int n7 = n4;
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (!bl) {
            if (!bl2 && l2 != 1L) {
                longMatrix1D2.assign(LongFunctions.mult(l2));
            }
            if (n8 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n9;
                int n10;
                n8 = 2;
                Future[] futureArray = new Future[n8];
                final long[] lArray4 = new long[n];
                int n11 = this.columns / n8;
                for (n10 = 0; n10 < n8; ++n10) {
                    n9 = n10 * n11;
                    final int n12 = n10 == n8 - 1 ? this.columns : n9 + n11;
                    final int n13 = n10;
                    futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (n13 == 0) {
                                for (int i = n9; i < n12; ++i) {
                                    int n = nArray2[i + 1];
                                    long l2 = lArray2[n6 + n5 * i];
                                    for (int j = nArray2[i]; j < n; ++j) {
                                        int n2 = nArray[j];
                                        int n32 = n4 + n3 * n2;
                                        lArray[n32] = lArray[n32] + l * lArray3[j] * l2;
                                    }
                                }
                            } else {
                                for (int i = n9; i < n12; ++i) {
                                    int n = nArray2[i + 1];
                                    long l3 = lArray2[n6 + n5 * i];
                                    for (int j = nArray2[i]; j < n; ++j) {
                                        int n42;
                                        int n52 = n42 = nArray[j];
                                        lArray4[n52] = lArray4[n52] + l * lArray3[j] * l3;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n9 = n10 = n % 10; n9 < n; n9 += 10) {
                    int n14 = n4 + n9 * n3;
                    lArray[n14] = lArray[n14] + lArray4[n9];
                    int n15 = n4 + (n9 + 1) * n3;
                    lArray[n15] = lArray[n15] + lArray4[n9 + 1];
                    int n16 = n4 + (n9 + 2) * n3;
                    lArray[n16] = lArray[n16] + lArray4[n9 + 2];
                    int n17 = n4 + (n9 + 3) * n3;
                    lArray[n17] = lArray[n17] + lArray4[n9 + 3];
                    int n18 = n4 + (n9 + 4) * n3;
                    lArray[n18] = lArray[n18] + lArray4[n9 + 4];
                    int n19 = n4 + (n9 + 5) * n3;
                    lArray[n19] = lArray[n19] + lArray4[n9 + 5];
                    int n20 = n4 + (n9 + 6) * n3;
                    lArray[n20] = lArray[n20] + lArray4[n9 + 6];
                    int n21 = n4 + (n9 + 7) * n3;
                    lArray[n21] = lArray[n21] + lArray4[n9 + 7];
                    int n22 = n4 + (n9 + 8) * n3;
                    lArray[n22] = lArray[n22] + lArray4[n9 + 8];
                    int n23 = n4 + (n9 + 9) * n3;
                    lArray[n23] = lArray[n23] + lArray4[n9 + 9];
                }
                for (n9 = 0; n9 < n10; ++n9) {
                    int n24 = n4 + n9 * n3;
                    lArray[n24] = lArray[n24] + lArray4[n9];
                }
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int n25 = nArray2[i + 1];
                    long l3 = lArray2[n6 + n5 * i];
                    for (int j = nArray2[i]; j < n25; ++j) {
                        int n26 = nArray[j];
                        int n27 = n4 + n3 * n26;
                        lArray[n27] = lArray[n27] + l * lArray3[j] * l3;
                    }
                }
            }
        } else if (n8 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n8];
            int n28 = this.columns / n8;
            for (int i = 0; i < n8; ++i) {
                final int n29 = i * n28;
                final int n30 = i == n8 - 1 ? this.columns : n29 + n28;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n29 * n3;
                        int n2 = SparseCCLongMatrix2D.this.columnPointers[n29];
                        for (int i = n29; i < n30; ++i) {
                            long l3 = 0L;
                            int n32 = SparseCCLongMatrix2D.this.columnPointers[i + 1];
                            while (n2 + 10 < n32) {
                                int n42 = n2 + 9;
                                l3 += lArray3[n42] * lArray2[n6 + n5 * SparseCCLongMatrix2D.this.rowIndexes[n42--]] + lArray3[n42] * lArray2[n6 + n5 * SparseCCLongMatrix2D.this.rowIndexes[n42--]] + lArray3[n42] * lArray2[n6 + n5 * SparseCCLongMatrix2D.this.rowIndexes[n42--]] + lArray3[n42] * lArray2[n6 + n5 * SparseCCLongMatrix2D.this.rowIndexes[n42--]] + lArray3[n42] * lArray2[n6 + n5 * SparseCCLongMatrix2D.this.rowIndexes[n42--]] + lArray3[n42] * lArray2[n6 + n5 * SparseCCLongMatrix2D.this.rowIndexes[n42--]] + lArray3[n42] * lArray2[n6 + n5 * SparseCCLongMatrix2D.this.rowIndexes[n42--]] + lArray3[n42] * lArray2[n6 + n5 * SparseCCLongMatrix2D.this.rowIndexes[n42--]] + lArray3[n42] * lArray2[n6 + n5 * SparseCCLongMatrix2D.this.rowIndexes[n42--]] + lArray3[n42] * lArray2[n6 + n5 * SparseCCLongMatrix2D.this.rowIndexes[n42--]];
                                n2 += 10;
                            }
                            while (n2 < n32) {
                                l3 += lArray3[n2] * lArray2[SparseCCLongMatrix2D.this.rowIndexes[n2]];
                                ++n2;
                            }
                            lArray[n] = l * l3 + l2 * lArray[n];
                            n += n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n31 = this.columnPointers[0];
            for (int i = 0; i < this.columns; ++i) {
                long l4 = 0L;
                int n32 = this.columnPointers[i + 1];
                while (n31 + 10 < n32) {
                    int n33 = n31 + 9;
                    l4 += lArray3[n33] * lArray2[n6 + n5 * this.rowIndexes[n33--]] + lArray3[n33] * lArray2[n6 + n5 * this.rowIndexes[n33--]] + lArray3[n33] * lArray2[n6 + n5 * this.rowIndexes[n33--]] + lArray3[n33] * lArray2[n6 + n5 * this.rowIndexes[n33--]] + lArray3[n33] * lArray2[n6 + n5 * this.rowIndexes[n33--]] + lArray3[n33] * lArray2[n6 + n5 * this.rowIndexes[n33--]] + lArray3[n33] * lArray2[n6 + n5 * this.rowIndexes[n33--]] + lArray3[n33] * lArray2[n6 + n5 * this.rowIndexes[n33--]] + lArray3[n33] * lArray2[n6 + n5 * this.rowIndexes[n33--]] + lArray3[n33] * lArray2[n6 + n5 * this.rowIndexes[n33--]];
                    n31 += 10;
                }
                while (n31 < n32) {
                    l4 += lArray3[n31] * lArray2[this.rowIndexes[n31]];
                    ++n31;
                }
                lArray[n7] = l * l4 + l2 * lArray[n7];
                n7 += n3;
            }
        }
        return longMatrix1D2;
    }

    public LongMatrix2D zMult(LongMatrix2D longMatrix2D, LongMatrix2D longMatrix2D2, long l, long l2, boolean bl, boolean bl2) {
        boolean bl3;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = longMatrix2D.rows();
        int n4 = longMatrix2D.columns();
        if (bl2) {
            n3 = longMatrix2D.columns();
            n4 = longMatrix2D.rows();
        }
        int n5 = n4;
        boolean bl4 = bl3 = longMatrix2D2 == null;
        if (longMatrix2D2 == null) {
            longMatrix2D2 = longMatrix2D instanceof SparseCCLongMatrix2D ? new SparseCCLongMatrix2D(n, n5, n * n5) : new DenseLongMatrix2D(n, n5);
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? longMatrix2D.viewDice() : longMatrix2D).toStringShort());
        }
        if (longMatrix2D2.rows() != n || longMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? longMatrix2D.viewDice() : longMatrix2D).toStringShort() + ", " + longMatrix2D2.toStringShort());
        }
        if (this == longMatrix2D2 || longMatrix2D == longMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3 && (double)l2 != 1.0) {
            longMatrix2D2.assign(LongFunctions.mult(l2));
        }
        if (longMatrix2D instanceof DenseLongMatrix2D && longMatrix2D2 instanceof DenseLongMatrix2D) {
            SparseCCLongMatrix2D sparseCCLongMatrix2D = bl ? this.getTranspose() : this;
            DenseLongMatrix2D denseLongMatrix2D = bl2 ? (DenseLongMatrix2D)longMatrix2D.viewDice() : (DenseLongMatrix2D)longMatrix2D;
            DenseLongMatrix2D denseLongMatrix2D2 = (DenseLongMatrix2D)longMatrix2D2;
            int[] nArray = sparseCCLongMatrix2D.columnPointers;
            int[] nArray2 = sparseCCLongMatrix2D.rowIndexes;
            long[] lArray = sparseCCLongMatrix2D.values;
            int n6 = (int)denseLongMatrix2D.index(0, 0);
            int n7 = denseLongMatrix2D.rowStride();
            int n8 = denseLongMatrix2D.columnStride();
            long[] lArray2 = denseLongMatrix2D.elements;
            int n9 = (int)denseLongMatrix2D2.index(0, 0);
            int n10 = denseLongMatrix2D2.rowStride();
            int n11 = denseLongMatrix2D2.columnStride();
            long[] lArray3 = denseLongMatrix2D2.elements;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n12 = nArray[j + 1];
                    long l3 = lArray2[n6 + j * n7 + i * n8];
                    for (int k = nArray[j]; k < n12; ++k) {
                        int n13 = nArray2[k];
                        int n14 = n9 + n13 * n10 + i * n11;
                        lArray3[n14] = lArray3[n14] + lArray[k] * l3;
                    }
                }
            }
            if ((double)l != 1.0) {
                longMatrix2D2.assign(LongFunctions.mult(l));
            }
        } else if (longMatrix2D instanceof SparseCCLongMatrix2D && longMatrix2D2 instanceof SparseCCLongMatrix2D) {
            SparseCCLongMatrix2D sparseCCLongMatrix2D = bl ? this.getTranspose() : this;
            SparseCCLongMatrix2D sparseCCLongMatrix2D2 = (SparseCCLongMatrix2D)longMatrix2D;
            if (bl2) {
                sparseCCLongMatrix2D2 = sparseCCLongMatrix2D2.getTranspose();
            }
            SparseCCLongMatrix2D sparseCCLongMatrix2D3 = (SparseCCLongMatrix2D)longMatrix2D2;
            int n15 = 0;
            int n16 = n;
            int n17 = n4;
            int[] nArray = sparseCCLongMatrix2D2.columnPointers;
            int[] nArray3 = sparseCCLongMatrix2D2.rowIndexes;
            long[] lArray = sparseCCLongMatrix2D2.values;
            int[] nArray4 = new int[n16];
            long[] lArray4 = new long[n16];
            int[] nArray5 = sparseCCLongMatrix2D3.columnPointers;
            int[] nArray6 = sparseCCLongMatrix2D3.rowIndexes;
            long[] lArray5 = sparseCCLongMatrix2D3.values;
            for (int i = 0; i < n17; ++i) {
                int n18 = sparseCCLongMatrix2D3.rowIndexes.length;
                if (n15 + n16 > n18) {
                    n18 = 2 * n18 + n16;
                    int[] nArray7 = new int[n18];
                    System.arraycopy(nArray6, 0, nArray7, 0, nArray6.length);
                    nArray6 = nArray7;
                    long[] lArray6 = new long[n18];
                    System.arraycopy(lArray5, 0, lArray6, 0, lArray5.length);
                    lArray5 = lArray6;
                }
                nArray5[i] = n15;
                for (n5 = nArray[i]; n5 < nArray[i + 1]; ++n5) {
                    n15 = this.scatter(sparseCCLongMatrix2D, nArray3[n5], lArray[n5], nArray4, lArray4, i + 1, sparseCCLongMatrix2D3, n15);
                }
                for (n5 = nArray5[i]; n5 < n15; ++n5) {
                    lArray5[n5] = lArray4[nArray6[n5]];
                }
            }
            nArray5[n17] = n15;
            if ((double)l != 1.0) {
                sparseCCLongMatrix2D3.assign(LongFunctions.mult(l));
            }
        } else {
            if (bl2) {
                longMatrix2D = longMatrix2D.viewDice();
            }
            LongMatrix1D[] longMatrix1DArray = new LongMatrix1D[n2];
            int n19 = n2;
            while (--n19 >= 0) {
                longMatrix1DArray[n19] = longMatrix2D.viewRow(n19);
            }
            LongMatrix1D[] longMatrix1DArray2 = new LongMatrix1D[n];
            int n20 = n;
            while (--n20 >= 0) {
                longMatrix1DArray2[n20] = longMatrix2D2.viewRow(n20);
            }
            LongPlusMultSecond longPlusMultSecond = LongPlusMultSecond.plusMult(0L);
            int[] nArray = this.rowIndexes;
            int[] nArray8 = this.columnPointers;
            long[] lArray = this.values;
            int n21 = this.columns;
            while (--n21 >= 0) {
                int n22 = nArray8[n21];
                int n23 = nArray8[n21 + 1];
                while (--n23 >= n22) {
                    int n24 = nArray[n23];
                    longPlusMultSecond.multiplicator = lArray[n23] * l;
                    if (!bl) {
                        longMatrix1DArray2[n24].assign(longMatrix1DArray[n21], longPlusMultSecond);
                        continue;
                    }
                    longMatrix1DArray2[n21].assign(longMatrix1DArray[n24], longPlusMultSecond);
                }
            }
        }
        return longMatrix2D2;
    }

    protected LongMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, long l) {
        IntArrayList intArrayList = new IntArrayList(this.rowIndexes);
        intArrayList.setSizeRaw(this.columnPointers[this.columns]);
        LongArrayList longArrayList = new LongArrayList(this.values);
        longArrayList.setSizeRaw(this.columnPointers[this.columns]);
        intArrayList.beforeInsert(n3, n);
        longArrayList.beforeInsert(n3, l);
        int n4 = this.columnPointers.length;
        while (--n4 > n2) {
            int n5 = n4;
            this.columnPointers[n5] = this.columnPointers[n5] + 1;
        }
        this.rowIndexes = intArrayList.elements();
        this.values = longArrayList.elements();
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.rowIndexes);
        LongArrayList longArrayList = new LongArrayList(this.values);
        intArrayList.remove(n2);
        longArrayList.remove(n2);
        int n3 = this.columnPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.columnPointers[n4] = this.columnPointers[n4] - 1;
        }
        this.rowIndexes = intArrayList.elements();
        this.values = longArrayList.elements();
    }

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }

    private long cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            l += (long)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return l;
    }

    private void realloc(int n) {
        if (n <= 0) {
            n = this.columnPointers[this.columns];
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.rowIndexes.length);
        System.arraycopy(this.rowIndexes, 0, nArray, 0, n2);
        this.rowIndexes = nArray;
        long[] lArray = new long[n];
        n2 = Math.min(n, this.values.length);
        System.arraycopy(this.values, 0, lArray, 0, n2);
        this.values = lArray;
    }

    private int scatter(SparseCCLongMatrix2D sparseCCLongMatrix2D, int n, long l, int[] nArray, long[] lArray, int n2, SparseCCLongMatrix2D sparseCCLongMatrix2D2, int n3) {
        int[] nArray2 = sparseCCLongMatrix2D.columnPointers;
        int[] nArray3 = sparseCCLongMatrix2D.rowIndexes;
        long[] lArray2 = sparseCCLongMatrix2D.values;
        int[] nArray4 = sparseCCLongMatrix2D2.rowIndexes;
        for (int i = nArray2[n]; i < nArray2[n + 1]; ++i) {
            int n4 = nArray3[i];
            if (nArray[n4] < n2) {
                nArray[n4] = n2;
                nArray4[n3++] = n4;
                if (lArray == null) continue;
                lArray[n4] = l * lArray2[i];
                continue;
            }
            if (lArray == null) continue;
            int n5 = n4;
            lArray[n5] = lArray[n5] + l * lArray2[i];
        }
        return n3;
    }
}

