/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleLUDecompositionQuick;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseCCMDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCMDoubleMatrix2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DoubleAMG
implements DoublePreconditioner {
    private SSOR[] preM;
    private SSOR[] postM;
    private int m;
    private SparseRCDoubleMatrix2D[] A;
    private DenseDoubleLUDecompositionQuick lu;
    private DenseDoubleMatrix1D[] u;
    private DenseDoubleMatrix1D[] f;
    private DenseDoubleMatrix1D[] r;
    private SparseCCDoubleMatrix2D[] I;
    private final int min;
    private final int nu1;
    private final int nu2;
    private final int gamma;
    private final double omegaPreF;
    private final double omegaPreR;
    private final double omegaPostF;
    private final double omegaPostR;
    private final boolean reverse;
    private final double omega;
    private boolean transpose;

    public DoubleAMG(double d, double d2, double d3, double d4, int n, int n2, int n3, int n4, double d5) {
        this.omegaPreF = d;
        this.omegaPreR = d2;
        this.omegaPostF = d3;
        this.omegaPostR = d4;
        this.reverse = true;
        this.nu1 = n;
        this.nu2 = n2;
        this.gamma = n3;
        this.min = n4;
        this.omega = d5;
    }

    public DoubleAMG(double d, double d2, int n, int n2, int n3, int n4, double d3) {
        this.omegaPreF = d;
        this.omegaPreR = d;
        this.omegaPostF = d2;
        this.omegaPostR = d2;
        this.reverse = false;
        this.nu1 = n;
        this.nu2 = n2;
        this.gamma = n3;
        this.min = n4;
        this.omega = d3;
    }

    public DoubleAMG() {
        this(1.0, 1.85, 1.85, 1.0, 1, 1, 1, 40, 0.6666666666666666);
    }

    public DoubleMatrix1D apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = doubleMatrix1D.like();
        }
        this.u[0].assign(doubleMatrix1D2);
        this.f[0].assign(doubleMatrix1D);
        this.transpose = false;
        this.cycle(0);
        return doubleMatrix1D2.assign(this.u[0]);
    }

    public DoubleMatrix1D transApply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = doubleMatrix1D.like();
        }
        this.u[0].assign(doubleMatrix1D2);
        this.f[0].assign(doubleMatrix1D);
        this.transpose = true;
        this.cycle(0);
        return doubleMatrix1D2.assign(this.u[0]);
    }

    public void setMatrix(DoubleMatrix2D doubleMatrix2D) {
        int n;
        double d;
        SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D;
        Aggregator aggregator;
        LinkedList<SparseRCDoubleMatrix2D> linkedList = new LinkedList<SparseRCDoubleMatrix2D>();
        LinkedList<SparseCCDoubleMatrix2D> linkedList2 = new LinkedList<SparseCCDoubleMatrix2D>();
        SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D2 = new SparseRCDoubleMatrix2D(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        sparseRCDoubleMatrix2D2.assign(doubleMatrix2D);
        if (!sparseRCDoubleMatrix2D2.hasColumnIndexesSorted()) {
            sparseRCDoubleMatrix2D2.sortColumnIndexes();
        }
        linkedList.add(sparseRCDoubleMatrix2D2);
        int n2 = 0;
        while (((SparseRCDoubleMatrix2D)linkedList.get(n2)).rows() > this.min && (aggregator = new Aggregator(sparseRCDoubleMatrix2D = (SparseRCDoubleMatrix2D)linkedList.get(n2), d = 0.08 * Math.pow(0.5, n2))).getAggregates().size() != 0) {
            Interpolator interpolator = new Interpolator(aggregator, sparseRCDoubleMatrix2D, this.omega);
            linkedList.add(interpolator.getGalerkinOperator());
            linkedList2.add(interpolator.getInterpolationOperator());
            ++n2;
        }
        this.m = linkedList.size();
        if (this.m == 0) {
            throw new RuntimeException("Matrix too small for AMG");
        }
        this.I = new SparseCCDoubleMatrix2D[this.m - 1];
        this.A = new SparseRCDoubleMatrix2D[this.m - 1];
        linkedList2.toArray(this.I);
        for (n2 = 0; n2 < linkedList.size() - 1; ++n2) {
            this.A[n2] = (SparseRCDoubleMatrix2D)linkedList.get(n2);
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(((SparseRCDoubleMatrix2D)linkedList.get(linkedList.size() - 1)).toArray());
        this.lu = new DenseDoubleLUDecompositionQuick();
        this.lu.decompose(denseDoubleMatrix2D);
        this.u = new DenseDoubleMatrix1D[this.m];
        this.f = new DenseDoubleMatrix1D[this.m];
        this.r = new DenseDoubleMatrix1D[this.m];
        for (n = 0; n < this.m; ++n) {
            int n3 = ((SparseRCDoubleMatrix2D)linkedList.get(n)).rows();
            this.u[n] = new DenseDoubleMatrix1D(n3);
            this.f[n] = new DenseDoubleMatrix1D(n3);
            this.r[n] = new DenseDoubleMatrix1D(n3);
        }
        this.preM = new SSOR[this.m - 1];
        this.postM = new SSOR[this.m - 1];
        for (n = 0; n < this.m - 1; ++n) {
            SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D3 = this.A[n];
            this.preM[n] = new SSOR(sparseRCDoubleMatrix2D3, this.reverse, this.omegaPreF, this.omegaPreR);
            this.postM[n] = new SSOR(sparseRCDoubleMatrix2D3, this.reverse, this.omegaPostF, this.omegaPostR);
            this.preM[n].setMatrix(sparseRCDoubleMatrix2D3);
            this.postM[n].setMatrix(sparseRCDoubleMatrix2D3);
        }
    }

    private void cycle(int n) {
        if (n == this.m - 1) {
            this.directSolve();
        } else {
            this.preRelax(n);
            this.u[n + 1].assign(0.0);
            this.A[n].zMult(this.u[n], this.r[n].assign(this.f[n]), -1.0, 1.0, false);
            this.I[n].zMult(this.r[n], this.f[n + 1], 1.0, 0.0, true);
            for (int i = 0; i < this.gamma; ++i) {
                this.cycle(n + 1);
            }
            this.I[n].zMult(this.u[n + 1], this.u[n], 1.0, 1.0, false);
            this.postRelax(n);
        }
    }

    private void directSolve() {
        int n = this.m - 1;
        this.u[n].assign(this.f[n]);
        if (this.transpose) {
            this.lu.setLU(this.lu.getLU().viewDice());
            this.lu.solve(this.u[n]);
            this.lu.setLU(this.lu.getLU().viewDice());
        } else {
            this.lu.solve(this.u[n]);
        }
    }

    private void preRelax(int n) {
        for (int i = 0; i < this.nu1; ++i) {
            if (this.transpose) {
                this.preM[n].transApply(this.f[n], this.u[n]);
                continue;
            }
            this.preM[n].apply(this.f[n], this.u[n]);
        }
    }

    private void postRelax(int n) {
        for (int i = 0; i < this.nu2; ++i) {
            if (this.transpose) {
                this.postM[n].transApply(this.f[n], this.u[n]);
                continue;
            }
            this.postM[n].apply(this.f[n], this.u[n]);
        }
    }

    private class SSOR
    implements DoublePreconditioner {
        private double omegaF;
        private double omegaR;
        private final SparseRCDoubleMatrix2D F;
        private final int[] diagind;
        private final double[] xx;
        private final boolean reverse;

        public SSOR(SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D, boolean bl, double d, double d2) {
            if (sparseRCDoubleMatrix2D.rows() != sparseRCDoubleMatrix2D.columns()) {
                throw new IllegalArgumentException("SSOR only applies to square matrices");
            }
            this.F = sparseRCDoubleMatrix2D;
            this.reverse = bl;
            this.setOmega(d, d2);
            int n = sparseRCDoubleMatrix2D.rows();
            this.diagind = new int[n];
            this.xx = new double[n];
        }

        public SSOR(SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D) {
            this(sparseRCDoubleMatrix2D, true, 1.0, 1.0);
        }

        public void setOmega(double d, double d2) {
            if (d < 0.0 || d > 2.0) {
                throw new IllegalArgumentException("omegaF must be between 0 and 2");
            }
            if (d2 < 0.0 || d2 > 2.0) {
                throw new IllegalArgumentException("omegaR must be between 0 and 2");
            }
            this.omegaF = d;
            this.omegaR = d2;
        }

        public void setMatrix(DoubleMatrix2D doubleMatrix2D) {
            this.F.assign(doubleMatrix2D);
            int n = this.F.rows();
            int[] nArray = this.F.getRowPointers();
            int[] nArray2 = this.F.getColumnIndexes();
            for (int i = 0; i < n; ++i) {
                this.diagind[i] = Sorting.binarySearchFromTo(nArray2, i, nArray[i], nArray[i + 1] - 1);
                if (this.diagind[i] >= 0) continue;
                throw new RuntimeException("Missing diagonal on row " + (i + 1));
            }
        }

        public DoubleMatrix1D apply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            int n;
            double d;
            int n2;
            if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D) || !(doubleMatrix1D2 instanceof DenseDoubleMatrix1D)) {
                throw new IllegalArgumentException("b and x must be a DenseDoubleMatrix1D");
            }
            int[] nArray = this.F.getRowPointers();
            int[] nArray2 = this.F.getColumnIndexes();
            double[] dArray = this.F.getValues();
            double[] dArray2 = ((DenseDoubleMatrix1D)doubleMatrix1D).elements();
            double[] dArray3 = ((DenseDoubleMatrix1D)doubleMatrix1D2).elements();
            int n3 = this.F.rows();
            System.arraycopy(dArray3, 0, this.xx, 0, n3);
            for (n2 = 0; n2 < n3; ++n2) {
                d = 0.0;
                for (n = nArray[n2]; n < this.diagind[n2]; ++n) {
                    d += dArray[n] * this.xx[nArray2[n]];
                }
                for (n = this.diagind[n2] + 1; n < nArray[n2 + 1]; ++n) {
                    d += dArray[n] * dArray3[nArray2[n]];
                }
                d = (dArray2[n2] - d) / dArray[this.diagind[n2]];
                this.xx[n2] = dArray3[n2] + this.omegaF * (d - dArray3[n2]);
            }
            if (!this.reverse) {
                System.arraycopy(this.xx, 0, dArray3, 0, n3);
                return doubleMatrix1D2;
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                d = 0.0;
                for (n = nArray[n2]; n < this.diagind[n2]; ++n) {
                    d += dArray[n] * this.xx[nArray2[n]];
                }
                for (n = this.diagind[n2] + 1; n < nArray[n2 + 1]; ++n) {
                    d += dArray[n] * dArray3[nArray2[n]];
                }
                d = (dArray2[n2] - d) / dArray[this.diagind[n2]];
                dArray3[n2] = this.xx[n2] + this.omegaR * (d - this.xx[n2]);
            }
            doubleMatrix1D2.assign(dArray3);
            return doubleMatrix1D2;
        }

        public DoubleMatrix1D transApply(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
            return this.apply(doubleMatrix1D, doubleMatrix1D2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Interpolator {
        private SparseRCDoubleMatrix2D Ac;
        private SparseCCDoubleMatrix2D I;

        public Interpolator(Aggregator aggregator, SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D, double d) {
            List<Set<Integer>> list = aggregator.getAggregates();
            List<Set<Integer>> list2 = aggregator.getNodeNeighborhoods();
            int[] nArray = aggregator.getDiagonalindexes();
            int[] nArray2 = this.createTentativeProlongation(list, sparseRCDoubleMatrix2D.rows());
            if (d != 0.0) {
                List<Map<Integer, Double>> list3 = this.createSmoothedProlongation(list, list2, sparseRCDoubleMatrix2D, nArray, d, nArray2);
                this.I = this.createInterpolationMatrix(list3, sparseRCDoubleMatrix2D.rows());
                this.Ac = this.createGalerkinSlow(this.I, sparseRCDoubleMatrix2D);
            } else {
                this.Ac = this.createGalerkinFast(sparseRCDoubleMatrix2D, nArray2, list.size());
                this.I = this.createInterpolationMatrix(nArray2, list.size());
            }
        }

        private int[] createTentativeProlongation(List<Set<Integer>> list, int n) {
            int[] nArray = new int[n];
            Arrays.fill(nArray, -1);
            for (int i = 0; i < list.size(); ++i) {
                for (int n2 : list.get(i)) {
                    nArray[n2] = i;
                }
            }
            return nArray;
        }

        private SparseRCDoubleMatrix2D createGalerkinFast(SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D, int[] nArray, int n) {
            int n2 = nArray.length;
            SparseRCMDoubleMatrix2D sparseRCMDoubleMatrix2D = new SparseRCMDoubleMatrix2D(n, n);
            int[] nArray2 = sparseRCDoubleMatrix2D.getRowPointers();
            int[] nArray3 = sparseRCDoubleMatrix2D.getColumnIndexes();
            double[] dArray = sparseRCDoubleMatrix2D.getValues();
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] == -1) continue;
                for (int j = nArray2[i]; j < nArray2[i + 1]; ++j) {
                    if (nArray[nArray3[j]] == -1) continue;
                    sparseRCMDoubleMatrix2D.setQuick(nArray[i], nArray[nArray3[j]], dArray[j]);
                }
            }
            return (SparseRCDoubleMatrix2D)new SparseRCDoubleMatrix2D(sparseRCMDoubleMatrix2D.rows(), sparseRCMDoubleMatrix2D.columns()).assign(sparseRCMDoubleMatrix2D);
        }

        private SparseCCDoubleMatrix2D createInterpolationMatrix(List<Map<Integer, Double>> list, int n) {
            int n2 = list.size();
            this.I = new SparseCCDoubleMatrix2D(n, n2);
            for (int i = 0; i < n2; ++i) {
                Map<Integer, Double> map = list.get(i);
                for (Map.Entry<Integer, Double> entry : map.entrySet()) {
                    this.I.setQuick(entry.getKey(), i, entry.getValue());
                }
            }
            return this.I;
        }

        private SparseCCDoubleMatrix2D createInterpolationMatrix(int[] nArray, int n) {
            SparseCCMDoubleMatrix2D sparseCCMDoubleMatrix2D = new SparseCCMDoubleMatrix2D(nArray.length, n);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1) continue;
                sparseCCMDoubleMatrix2D.setQuick(i, nArray[i], 1.0);
            }
            return (SparseCCDoubleMatrix2D)new SparseCCDoubleMatrix2D(sparseCCMDoubleMatrix2D.rows(), sparseCCMDoubleMatrix2D.columns()).assign(sparseCCMDoubleMatrix2D);
        }

        public SparseCCDoubleMatrix2D getInterpolationOperator() {
            return this.I;
        }

        private List<Map<Integer, Double>> createSmoothedProlongation(List<Set<Integer>> list, List<Set<Integer>> list2, SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D, int[] nArray, double d, int[] nArray2) {
            int n = sparseRCDoubleMatrix2D.rows();
            int n2 = list.size();
            ArrayList<Map<Integer, Double>> arrayList = new ArrayList<Map<Integer, Double>>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add(new HashMap());
            }
            int[] nArray3 = sparseRCDoubleMatrix2D.getRowPointers();
            int[] nArray4 = sparseRCDoubleMatrix2D.getColumnIndexes();
            double[] dArray = sparseRCDoubleMatrix2D.getValues();
            double[] dArray2 = new double[n2];
            for (int i = 0; i < n; ++i) {
                if (nArray2[i] == -1) continue;
                Arrays.fill(dArray2, 0.0);
                Set<Integer> set = list2.get(i);
                double d2 = 0.0;
                for (int j = nArray3[i]; j < nArray3[i + 1]; ++j) {
                    if (nArray2[nArray4[j]] == -1) continue;
                    double d3 = dArray[j];
                    if (d3 != 0.0 && !set.contains(nArray4[j])) {
                        d2 += d3;
                        continue;
                    }
                    int n3 = nArray2[nArray4[j]];
                    dArray2[n3] = dArray2[n3] + d3;
                }
                int n4 = nArray2[i];
                dArray2[n4] = dArray2[n4] - d2;
                double d4 = -d / dArray[nArray[i]];
                int n5 = 0;
                while (n5 < dArray2.length) {
                    int n6 = n5++;
                    dArray2[n6] = dArray2[n6] * d4;
                }
                int n7 = nArray2[i];
                dArray2[n7] = dArray2[n7] + 1.0;
                for (n5 = 0; n5 < dArray2.length; ++n5) {
                    if (dArray2[n5] == 0.0) continue;
                    ((Map)arrayList.get(n5)).put(i, dArray2[n5]);
                }
            }
            return arrayList;
        }

        private SparseRCDoubleMatrix2D createGalerkinSlow(SparseCCDoubleMatrix2D sparseCCDoubleMatrix2D, SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D) {
            int n = sparseCCDoubleMatrix2D.rows();
            int n2 = sparseCCDoubleMatrix2D.columns();
            SparseRCMDoubleMatrix2D sparseRCMDoubleMatrix2D = new SparseRCMDoubleMatrix2D(n2, n2);
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(n, dArray, 0, 1, false);
            DenseDoubleMatrix1D denseDoubleMatrix1D2 = new DenseDoubleMatrix1D(n, dArray2, 0, 1, false);
            double[] dArray3 = new double[n2];
            DenseDoubleMatrix1D denseDoubleMatrix1D3 = new DenseDoubleMatrix1D(n2, dArray3, 0, 1, false);
            int[] nArray = sparseCCDoubleMatrix2D.getColumnPointers();
            int[] nArray2 = sparseCCDoubleMatrix2D.getRowIndexes();
            double[] dArray4 = sparseCCDoubleMatrix2D.getValues();
            for (int i = 0; i < n2; ++i) {
                int n3;
                denseDoubleMatrix1D2.assign(0.0);
                for (n3 = nArray[i]; n3 < nArray[i + 1]; ++n3) {
                    dArray2[nArray2[n3]] = dArray4[n3];
                }
                sparseRCDoubleMatrix2D.zMult(denseDoubleMatrix1D2, denseDoubleMatrix1D);
                sparseCCDoubleMatrix2D.zMult(denseDoubleMatrix1D, denseDoubleMatrix1D3, 1.0, 0.0, true);
                for (n3 = 0; n3 < n2; ++n3) {
                    if (dArray3[n3] == 0.0) continue;
                    sparseRCMDoubleMatrix2D.setQuick(n3, i, dArray3[n3]);
                }
            }
            return (SparseRCDoubleMatrix2D)new SparseRCDoubleMatrix2D(sparseRCMDoubleMatrix2D.rows(), sparseRCMDoubleMatrix2D.columns()).assign(sparseRCMDoubleMatrix2D);
        }

        public SparseRCDoubleMatrix2D getGalerkinOperator() {
            return this.Ac;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Aggregator {
        private List<Set<Integer>> C;
        private int[] diagind;
        private List<Set<Integer>> N;

        public Aggregator(SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D, double d) {
            this.diagind = this.findDiagonalindexes(sparseRCDoubleMatrix2D);
            this.N = this.findNodeNeighborhood(sparseRCDoubleMatrix2D, this.diagind, d);
            boolean[] blArray = this.createInitialR(sparseRCDoubleMatrix2D);
            this.C = this.createInitialAggregates(this.N, blArray);
            this.C = this.enlargeAggregates(this.C, this.N, blArray);
            this.C = this.createFinalAggregates(this.C, this.N, blArray);
        }

        public List<Set<Integer>> getAggregates() {
            return this.C;
        }

        public int[] getDiagonalindexes() {
            return this.diagind;
        }

        public List<Set<Integer>> getNodeNeighborhoods() {
            return this.N;
        }

        private int[] findDiagonalindexes(SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D) {
            int[] nArray = sparseRCDoubleMatrix2D.getRowPointers();
            int[] nArray2 = sparseRCDoubleMatrix2D.getColumnIndexes();
            int[] nArray3 = new int[sparseRCDoubleMatrix2D.rows()];
            for (int i = 0; i < sparseRCDoubleMatrix2D.rows(); ++i) {
                nArray3[i] = Sorting.binarySearchFromTo(nArray2, i, nArray[i], nArray[i + 1]);
                if (nArray3[i] >= 0) continue;
                throw new RuntimeException("Matrix is missing a diagonal entry on row " + (i + 1));
            }
            return nArray3;
        }

        private List<Set<Integer>> findNodeNeighborhood(SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D, int[] nArray, double d) {
            this.N = new ArrayList<Set<Integer>>(sparseRCDoubleMatrix2D.rows());
            int[] nArray2 = sparseRCDoubleMatrix2D.getRowPointers();
            int[] nArray3 = sparseRCDoubleMatrix2D.getColumnIndexes();
            double[] dArray = sparseRCDoubleMatrix2D.getValues();
            for (int i = 0; i < sparseRCDoubleMatrix2D.rows(); ++i) {
                HashSet<Integer> hashSet = new HashSet<Integer>();
                double d2 = dArray[nArray[i]];
                for (int j = nArray2[i]; j < nArray2[i + 1]; ++j) {
                    double d3 = dArray[j];
                    double d4 = dArray[nArray[nArray3[j]]];
                    if (!(Math.abs(d3) >= d * Math.sqrt(d2 * d4))) continue;
                    hashSet.add(nArray3[j]);
                }
                this.N.add(hashSet);
            }
            return this.N;
        }

        private boolean[] createInitialR(SparseRCDoubleMatrix2D sparseRCDoubleMatrix2D) {
            boolean[] blArray = new boolean[sparseRCDoubleMatrix2D.rows()];
            int[] nArray = sparseRCDoubleMatrix2D.getRowPointers();
            int[] nArray2 = sparseRCDoubleMatrix2D.getColumnIndexes();
            double[] dArray = sparseRCDoubleMatrix2D.getValues();
            for (int i = 0; i < sparseRCDoubleMatrix2D.rows(); ++i) {
                boolean bl = false;
                for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                    if (nArray2[j] == i || dArray[j] == 0.0) continue;
                    bl = true;
                    break;
                }
                blArray[i] = bl;
            }
            return blArray;
        }

        private List<Set<Integer>> createInitialAggregates(List<Set<Integer>> list, boolean[] blArray) {
            this.C = new ArrayList<Set<Integer>>();
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                boolean bl = true;
                for (int n : list.get(i)) {
                    bl &= blArray[n];
                }
                if (!bl) continue;
                this.C.add(new HashSet(list.get(i)));
                for (int n : list.get(i)) {
                    blArray[n] = false;
                }
            }
            return this.C;
        }

        private List<Set<Integer>> enlargeAggregates(List<Set<Integer>> list, List<Set<Integer>> list2, boolean[] blArray) {
            int n;
            ArrayList arrayList = new ArrayList(blArray.length);
            for (n = 0; n < blArray.length; ++n) {
                arrayList.add(new ArrayList());
            }
            for (n = 0; n < list.size(); ++n) {
                for (int n2 : list.get(n)) {
                    ((List)arrayList.get(n2)).add(n);
                }
            }
            int[] nArray = new int[list.size()];
            for (int i = 0; i < blArray.length; ++i) {
                int n2;
                if (!blArray[i]) continue;
                Arrays.fill(nArray, 0);
                n2 = 0;
                int n3 = 0;
                for (int n4 : list2.get(i)) {
                    Iterator iterator = ((List)arrayList.get(n4)).iterator();
                    while (iterator.hasNext()) {
                        int n5;
                        int n6 = n5 = ((Integer)iterator.next()).intValue();
                        nArray[n6] = nArray[n6] + 1;
                        if (nArray[n5] <= n3) continue;
                        n2 = n5;
                        n3 = nArray[n2];
                    }
                }
                if (n3 <= 0) continue;
                blArray[i] = false;
                list.get(n2).add(i);
            }
            return list;
        }

        private List<Set<Integer>> createFinalAggregates(List<Set<Integer>> list, List<Set<Integer>> list2, boolean[] blArray) {
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (int n : list2.get(i)) {
                    if (!blArray[n]) continue;
                    blArray[n] = false;
                    hashSet.add(n);
                }
                if (hashSet.isEmpty()) continue;
                list.add(hashSet);
            }
            return list;
        }
    }
}

