/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.http;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class CookieManager {
    private Map store = new HashMap();
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String COOKIE_VALUE_DELIMITER = ";";
    private static final String PATH = "path";
    private static final String EXPIRES = "expires";
    private static final String DATE_FORMAT = "EEE, dd-MMM-yyyy hh:mm:ss z";
    private static final String SET_COOKIE_SEPARATOR = "; ";
    private static final String COOKIE = "Cookie";
    private static final char NAME_VALUE_SEPARATOR = '=';
    private static final char DOT = '.';
    private DateFormat dateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z");
    private static CookieManager instance = null;

    private CookieManager() {
    }

    public static synchronized CookieManager getInstance() {
        if (instance == null) {
            instance = new CookieManager();
        }
        return instance;
    }

    public void storeCookies(URLConnection uRLConnection) throws IOException {
        Map map;
        String string = this.getDomainFromHost(uRLConnection.getURL().getHost());
        if (this.store.containsKey(string)) {
            map = (Map)this.store.get(string);
        } else {
            map = new HashMap();
            this.store.put(string, map);
        }
        String string2 = null;
        int n = 1;
        while ((string2 = uRLConnection.getHeaderFieldKey(n)) != null) {
            if (string2.equalsIgnoreCase(SET_COOKIE)) {
                String string3;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                StringTokenizer stringTokenizer = new StringTokenizer(uRLConnection.getHeaderField(n), COOKIE_VALUE_DELIMITER);
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    String string4 = string3.substring(0, string3.indexOf(61));
                    String string5 = string3.substring(string3.indexOf(61) + 1, string3.length());
                    map.put(string4, hashMap);
                    hashMap.put(string4, string5);
                }
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    hashMap.put(string3.substring(0, string3.indexOf(61)).toLowerCase(), string3.substring(string3.indexOf(61) + 1, string3.length()));
                }
            }
            ++n;
        }
    }

    public void setCookies(URLConnection uRLConnection) throws IOException {
        Object object;
        URL uRL = uRLConnection.getURL();
        String string = this.getDomainFromHost(uRL.getHost());
        String string2 = uRL.getPath();
        Map map = (Map)this.store.get(string);
        if (map == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            object = (Map)map.get(string3);
            if (!this.comparePaths((String)object.get(PATH), string2) || !this.isNotExpired((String)object.get(EXPIRES))) continue;
            stringBuffer.append(string3);
            stringBuffer.append("=");
            String string4 = (String)object.get(string3);
            stringBuffer.append(string4);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(SET_COOKIE_SEPARATOR);
        }
        try {
            uRLConnection.setRequestProperty(COOKIE, stringBuffer.toString());
        }
        catch (IllegalStateException illegalStateException) {
            object = new IOException("Illegal State! Cookies cannot be set on a URLConnection that is already connected. Only call setCookies(java.net.URLConnection) AFTER calling java.net.URLConnection.connect().");
            throw object;
        }
    }

    private String getDomainFromHost(String string) {
        if (string.indexOf(46) != string.lastIndexOf(46)) {
            return string.substring(string.indexOf(46) + 1);
        }
        return string;
    }

    private boolean isNotExpired(String string) {
        if (string == null) {
            return true;
        }
        Date date = new Date();
        try {
            return date.compareTo(this.dateFormat.parse(string)) <= 0;
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return false;
        }
    }

    private boolean comparePaths(String string, String string2) {
        if (string == null) {
            return true;
        }
        if (string.equals("/")) {
            return true;
        }
        return string2.regionMatches(0, string, 0, string.length());
    }
}

