## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(echo = TRUE,
                      results = TRUE,
                      warning = FALSE,
                      message = FALSE,
                      comment = "",
                      collapse = FALSE,
                      class.source = "bg-success",
                      class.output = "bg-warning")

## ----setup--------------------------------------------------------------------
library(healthequal)
require(dplyr)

## -----------------------------------------------------------------------------
data(OrderedSample)
head(OrderedSample, n = 4)

## -----------------------------------------------------------------------------
data(NonorderedSample)
head(NonorderedSample, n = 4)

## -----------------------------------------------------------------------------
data(OrderedSampleMultipleind)
head(OrderedSampleMultipleind, n = 4)

## -----------------------------------------------------------------------------
data(NonorderedSampleMultipleind)
head(NonorderedSampleMultipleind, n = 4)

## -----------------------------------------------------------------------------
?healthequal::OrderedSample
?healthequal::NonorderedSample
?healthequal::OrderedSampleMultipleind
?healthequal::NonorderedSampleMultipleind
?healthequal::IndividualSample

## -----------------------------------------------------------------------------
?aci

## -----------------------------------------------------------------------------
with(OrderedSample,
     aci(est = estimate,
         subgroup_order = subgroup_order,
         pop = population))

## -----------------------------------------------------------------------------
?sii

## -----------------------------------------------------------------------------
with(IndividualSample,
     aci(est = sba,
         subgroup_order = subgroup_order,
         weight = weight,
         psu = psu,
         strata = strata))

## -----------------------------------------------------------------------------
with(NonorderedSample,
     bgv(est = estimate,
         se = se, 
         pop = population))

## -----------------------------------------------------------------------------
head(NonorderedSampleMultipleind, n = 4)
unique(NonorderedSampleMultipleind$indicator)

## -----------------------------------------------------------------------------
library(dplyr)
measures <- NonorderedSampleMultipleind %>%
  dplyr::group_by(indicator) %>%
  dplyr::summarize(covar(est = estimate,
                         se = se, 
                         pop = population,
                         scaleval = indicator_scale))

as.data.frame(measures) 

## -----------------------------------------------------------------------------
multiplemeasures <- NonorderedSampleMultipleind %>%
  dplyr::group_by(indicator,
                  dimension) %>%
  dplyr::summarize(
    covar = covar(est = estimate,
                  se = se, 
                  pop = population,
                  scaleval = indicator_scale),
    bgv = bgv(est = estimate,
              se = se, 
              pop = population)) 

# It is possible to extract the measures separately
multiplemeasures$covar
multiplemeasures$bgv

